#include "AD18F08.h"
#include <stdio.h>
#include "common.h"

/*******************************************************************************
// ----Function: GPIO_Init
// --Parameters: 
// -----Returns: None   
//---------Note:所有IO初始化
*******************************************************************************/

void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式
	
	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0
	
	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉
	
	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出
	
	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}

/*******************************************************************************
// ----Function: Timer0_Init
// --Parameters: 
// -----Returns: None   
//---------Note: 定时器0初始化，定时10ms
				Fcpu作为TMR0时钟：
					4T  t=PR0*定时器0分频系数*4T/16MHz
					2T  t=PR0*定时器0分频系数*2T/16MHz
				其它时钟源作为TMR0时钟：
					t=PR0*定时器0分频系数/osc
*******************************************************************************/
void Timer1_Timer(void)
{
	TMR1H  = 0XFC;     //10ms
	TMR1L  = 0X18;
	T1CON0 = 0X25;     //  4分频   16M     使能timer1
	T1CON1 = 0X00;     //   模式0

	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //开TMR1中断	

	// WDTCON = 0X01;
	// ADCON0 = 0X01;
	// ADCON1 = 0XBE;
	// ADCON2 = 0X01;
	
	// ADIF = 0;      //清中断标志
	// ADIP = 1;		 //高优先级中断
	// ADIE = 1;      //开AD中断	

}

void Timer1_edge(void)
{
	TRISB6 = 1;
	TRISB7 = 1;
	TRISA4 = 1;

	TMR1H  = 0X0E;
	TMR1L  = 0X10;
	T1CON0 = 0X25;  // 4分频   16M   使能timer1
	T1CON1 = 0X02;  //上升沿开始，下降沿结束，模式1

	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //开TMR1中断
	INT2IF = 0;
	INT2IP = 1;
	INT2IE = 1;

	// PR2H = 0X03;
	// PR2L = 0XE8;
	// TMR1H  = 0X00;
	// TMR1L  = 0X00;
	// T2CON = 0X05; 
	// TMR2IF = 0;      //清中断标志
	// TMR2IP = 1;		 //高优先级中断
	// TMR2IE = 1;      //开TMR2中断	
}

//Pch:0-PB6,1-PA3,2-PB4,3-PA0,4-DAC,5-ADC_MUX,6-FVR,7-GND
//Nch:0-PB7,1-PA5,2-PA2,3-PB2,4-DAC,5-ADC_MUX,6-FVR,7-PA1
//Mode<7>:  0-不输出到IO(PB6),1-输出到IO(PB6)
//Mode<6>:  0-不输出到IO(PB1),1-输出到IO(PB1)
//Mode<5>:  0-不输出到IO(PA5),1-输出到IO(PA5)
//Mode<4>:  0-不输出到IO(PA1),1-输出到IO(PA1)
//Mode<0>:  0-禁止,1-使能
void Cmp_Cfg(unsigned char Pch,unsigned char Nch,unsigned char Mode)
{
	if(Mode&0X01)
	{
		CMPCLKEN=1;

		CMPCON0=0X80;	//CMP使能
		//CMPPOS=0;	//不取反
		CMPCON0|=Pch<<3;	//同相端
		CMPCON0|=Nch;	//同相端

		CMPCON1=0<<6;	//下降沿迟滞，0-0mv,1-14mv,2-21mv,3-41mv
		CMPCON1|=0<<4;	//上身沿迟滞，0-0mv,1-12mv,2-18mv,3-38mv

		CMPCON2=0<<4;	//滤波时间：T=(CMPFILTER[3:0]<<4+15)/Fcpu，0-不滤波
		C0OUT0EN=1;
	
		if((Mode&0X80)==0x80)
		{
			C0OUT3EN=1;		//PB6输出
			PB6AEN=0;
			TRISB6=0;
			// PB6PD=1;
			// PB6PU=1;
		}
		else	
		{
			C0OUT3EN=0;	
		}

		if((Mode&0X40)==0x40)
		{
			C0OUT2EN=1;		//PB1输出
			TRISB1=0;
			// PB1PD=1;
			// PB1PU=1;
		}
		else
		{
			C0OUT2EN=0;		
		}

		if((Mode&0X20)==0x20)
		{
			C0OUT1EN=1;		//PA5输出
			TRISA5=0;
			// PA5PD=1;
			// PA5PU=1;
		}
		else	
		{
			C0OUT1EN=0;		
		}

		if((Mode&0X10)==0x10)
		{
			C0OUT0EN=1;		//PA1输出
			TRISA1=0;
			// PA1PD=1;
			// PB7PU=1;
		}
		else
		{
			C0OUT0EN=0;
		}

	}
	else
	{
		CMPCLKEN=0;
		CMPCON0=0X00;
	}
	
}